﻿/*
make_unit.sqf
*/
private ["_group","_pos","_skill","_val","_idx","_data","_z","_arr2","_type","_txt_side","_data","_dir","_n"];

#include "ACV_Constantes.h"
#include "macros.sqf";


FNCT_MakeGroupA = {
	_side = _this select 0;
	_group = grpnull;
	if (_side==0) then {
		_group = createGroup east;
	};
	if (_side==1) then {
		_group = createGroup west;
	};
	if (_side==2) then {
		_group = createGroup resistance;
	};
	if (_side==3) then {
		_group = createGroup civilian;
	};
	sleep 0.01;
	_group;
};

FNCT_MakeGroupB = {
	_side = _this select 0;
	_group = grpnull;
	if(_side=="EAST") then {
		_group = createGroup east;
	};
	if(_side=="WEST") then {
		_group = createGroup west;
	};
	if(_side=="GUER") then {
		_group = createGroup resistance;
	};
	if(_side=="CIV") then {
        _group = createGroup civilian;
	};
	sleep 0.01;
	_group;
};

FNCT_MakeUnit_MAN = {
	_class	= _this select 0;
	_pos	= _this select 1;
	_group	= _this select 2;
	_skill	= _this select 3;
	_dir	= _this select 4;
	_rank	= _this select 5;
	/*
	diag_log format["_pos: %1",_pos];
	diag_log format["_group: %1",_group];
	diag_log format["_skill: %1",_skill];
	diag_log format["_rank: %1",_rank];
	diag_log format["_class: %1",_class];
	*/
	_class createUnit [_pos, _group, "ACV_Void=this", _skill, _rank];

	sleep 0.01;
	/*
	diag_log format["ACV_Void: %1",ACV_Void];
	*/
	ACV_Void setPos [_pos select 0, _pos select 1, 0];

	if (ACV_CleanDead) then {
		GestDead(ACV_Void);
	};
	
	ACV_Void setDir _dir;
	sleep 0.01;
	ACV_Void;
};

FNCT_MakeVehicleA = {
	_class	= _this select 0;
	_pos	= _this select 1;
	_dir	= _this select 2;
	if ( (ACV_Default_EnVol ==0 )  && (_class isKindOf "Air") ) then {
    	ACV_Void = createVehicle [_class, [_pos select 0, _pos select 1, 200],[],0,"FLY"];
    	sleep 0.01;
    	ACV_Void setPos [_pos select 0, _pos select 1, 200];
    }else{
    	ACV_Void = _class createVehicle _pos;
    	sleep 0.01;
    	ACV_Void setPos [_pos select 0, _pos select 1, 0];
    };
    ACV_Void addAction [ "A.C.V" call ACV_FNCT_Red, "R3F\ACV\Dlg\show_main_dlg.sqf","", 100,   false, false, "", "player in _target"];
    if (ACV_CleanDead) then {
    	GestDead(ACV_Void);
    };
    ACV_Void setDir _dir;
    sleep 0.01;
    ACV_Void;
};

FNCT_AssignInVehicle = {
	_nx				= _this select 0;
	_vehicleClass	= _this select 1;
	_vehicleTurrets	= _this select 2;
	_unit			= _this select 3;
	_veh			= _this select 4;
	if ( (_vehicleClass == "WarfareBuildingsClassname") || _vehicleTurrets) then {
		_unit moveInGunner _veh;
	}else{
		if(_nx==0) then {
			_unit moveInDriver _veh;
		};
		if(_nx==1) then {
			_unit moveInGunner _veh;
		};
		if(_nx==2) then {
			_unit moveInCommander _veh;
		};
		if(_nx>2) then {
			_unit moveInCargo _veh;
		};
	};

	sleep 0.01;
};


disableSerialization;

_mk_unit = (_this select 0) == -1;
_mk_grp = (_this select 0) == -2;
_mk_mun = (_this select 0) == -3;
_mk_obj = (_this select 0) == -4;

_display = uiNamespace getVariable "R3F_ACV_MAIN_DLG";
_cb_unit = _display displayCtrl ACV_DLG_ID_Main_CbUnit;
_cb_skill = _display displayCtrl ACV_DLG_ID_Main_CbSkill;
_cb_grp = _display displayCtrl ACV_DLG_ID_Main_GrpCbUnit;
_edit_rayon = _display displayCtrl ACV_DLG_ID_Main_EditRayon;
_cb_mun = _display displayCtrl ACV_DLG_ID_Main_CbMun;
_cb_obj = _display displayCtrl ACV_DLG_ID_Main_CbObj;

ACV_Default_Rayon = (ctrlText _edit_rayon);

_txt_sys = _display displayCtrl ACV_DLG_ID_Main_TxtSystem;

_dir = ACV_Default_Direction;

if( _mk_grp) then {
	_idx = lbCurSel _cb_grp;
	_val = _cb_grp lbvalue _idx;
	_data = _cb_grp lbdata _idx;
 	_skill = ACV_SKILLARRAY select (_cb_skill lbvalue _idx);
	_skill = _skill select 0;
	ACV_Default_Skill = _idx;
	[_txt_sys,"Cliquez sur la carte pour placer le groupe"] spawn ACV_FNCT_FlashMessage;
};
if(_mk_unit) then {
	_idx = lbCurSel _cb_unit;
	_data = ACV_UNITSARRAY select (_cb_unit lbvalue _idx);
	_idx = lbCurSel _cb_skill;
	_skill = ACV_SKILLARRAY select (_cb_skill lbvalue _idx);
	_skill = _skill select 0;
	ACV_Default_Skill = _idx;
	_txt_side = _data select 0;
	_type = _data select 2;
	_class = _data select 4;
	[_txt_sys,"Cliquez sur la carte pour placer l'objet"] spawn ACV_FNCT_FlashMessage;
};
if(_mk_mun) then {
	_idx = lbCurSel _cb_mun;
	_class = (ACV_MUN select _idx) select 0;
	_displayname = (ACV_MUN select _idx) select 1;
	[_txt_sys,"Cliquez sur la carte pour placer l'objet"] spawn ACV_FNCT_FlashMessage;
};
if(_mk_obj) then {
	_idx = lbCurSel _cb_obj;
	_class = _cb_obj lbdata _idx;
	_displayname = _cb_obj lbtext _idx;
	[_txt_sys,"Cliquez sur la carte pour placer l'objet"] spawn ACV_FNCT_FlashMessage;
};
ACV_Pos = false;
ACV_Void = false;
ACV_Go = false;
onMapSingleClick "ACV_Pos = _pos;ACV_Void = true;ACV_Go = true;true;";
waitUntil {ACV_Void};
onMapSingleClick "";

if( ! ACV_Go ) exitWith {};

_pos = ACV_Pos;
_group = grpNull;
if( _mk_grp ) then {
	_arr_grp = ACV_GRPARRAY select _val;
	
	_i = _arr_grp select 9;
	_ii = _arr_grp select 10;
    _iii = _arr_grp select 11;
    _iiii = _arr_grp select 12;
    _arr2 = _arr_grp select 13;

	_entry = (configFile >> "CfgGroups") select _i;
	_entry2 = _entry select _ii;
	_entry3 = _entry2 select _iii;
	_entry4 = _entry3 select _iiii;
	
	_first = true;
	_classname = "";
	
	_n = 0;
	_nx = 0;
	for  [ {_z = 0}, {_z < (count(_arr2 ) / 4)}, {_z = _z +1}] do {
		_class = _arr2 select _n;
		_side = _arr2 select (_n + 1);
		_rank = _arr2 select (_n + 2);
		_ofpos = _arr2 select (_n + 3);
		
    	_n = _n + 4;
		if ( _first) then {
			_first = false;
    		_group = [_side] call FNCT_MakeGroupA;
		};

		_newpos = [ (_pos select 0) + (_ofpos select 0), (_pos select 1)+ (_ofpos select 1), (_pos select 2)+ (_ofpos select 2)];

		if (_class isKindOf "Man") then {
			ACV_Void = [_class,_newpos,_group,_skill,_dir,_rank] call FNCT_MakeUnit_MAN;
		}else{
			_veh = [_class, _newpos, _dir] call FNCT_MakeVehicleA;
			_vehicle set [count(_vehicle), _veh];
			_nx=0;
			if (isArray (configFile >> "CfgVehicles" >>_class >> "typicalCargo")) then {
				_crew = getArray (configFile >> "CfgVehicles" >> _class >> "typicalCargo");
				{
					_newpos = [ (_pos select 0) + (_ofpos select 0), (_pos select 1)+ (_ofpos select 1), (_pos select 2)+ (_ofpos select 2)];
					ACV_Void = [_x,_newpos,_group,_skill,0,_rank] call FNCT_MakeUnit_MAN;				
					[_nx, _class, false, ACV_Void, _veh] call FNCT_AssignInVehicle;
					if( ! (ACV_Void  in _veh) ) then {
						deletevehicle ACV_Void;
						sleep 0.01;
						//diag_log format["%1 %2",_x, ACV_Void  in _veh];
					};
					_nx = _nx + 1;
				}foreach _crew;
			};
		};
    };
 	
 	[(leader _group),_group,true] call ACV_FNCT_StockUnit;
 	
   	_s = format["%1 créé",getText (_entry4 >> "name")];
   	
   	_txt_sys ctrlSetText _s;
	
	if(ACV_NetMsg) then {
		R3F_CrossRoad = format["%1 par %2",_s, (name player)];
		publicVariable R3F_CrossRoad;
	};
};
if(_mk_unit) then { // Creation unités simples
	_idx = lbCurSel _cb_unit;
	_data = ACV_UNITSARRAY select (_cb_unit lbvalue _idx);
	_idx = lbCurSel _cb_skill;
	_skill = ACV_SKILLARRAY select (_cb_skill lbvalue _idx);
	_skill = _skill select 0;
	_txt_side = _data select 0;
	_type = _data select 2;
	_class = _data select 4;
	_rank = "corporal";
	_ofpos = [0,0,0];
	_group = [_txt_side] call FNCT_MakeGroupB;
    if(_type=="MAN") then {	
		ACV_Void = [_class,_pos,_group,_skill,_dir,_rank] call FNCT_MakeUnit_MAN;	
		//_veh = ACV_Void; 
    }else{
    	//diag_log format["%1",_class];
		ACV_Void = [_class, _pos, _dir] call FNCT_MakeVehicleA;
		
		sleep 0.01;
    	_veh = ACV_Void;    	
    	if( ACV_Default_Empty == 1) then {
    		_nx=0;
			if (isArray (configFile >> "CfgVehicles" >>_class >> "typicalCargo")) then {
				_crew = getArray (configFile >> "CfgVehicles" >> _class >> "typicalCargo");
				_vehicleClass = getText (configFile >> "CfgVehicles" >> _class >> "vehicleClass");
				_vehicleTurrets = (isClass (configFile >> "CfgVehicles" >> _class >> "Turrets") && ( (count _crew) == 1));
				
				{
					_newpos = [ (_pos select 0) + (_ofpos select 0), (_pos select 1)+ (_ofpos select 1), (_pos select 2)+ (_ofpos select 2)];
					ACV_Void = [_x,_newpos,_group,_skill,0,_rank] call FNCT_MakeUnit_MAN;
							
					_n = [_nx, _vehicleClass, _vehicleTurrets, ACV_Void, _veh] call FNCT_AssignInVehicle;
					if( ! (ACV_Void  in _veh) ) then {
						deletevehicle ACV_Void;
						sleep 0.01;
					};
					_nx = _nx + 1;
				}foreach _crew;
			};
    	}else{
    		if(_type=="AIR") then {
		 		_veh addAction ["HALO", "R3F\ACV\Dlg\halo.sqf",[_veh],0, false, false, "", " ((getpos _this) select 2) > 50"];
			};
			_group = grpnull;
    	};
    	ACV_Void = _veh;
    };
	sleep 0.01;

	[ACV_Void,_group,false] call ACV_FNCT_StockUnit;

	_s = format["%1 créé",getText (configFile >> "CfgVehicles" >> typeof ACV_Void >> "displayName")];	
	_txt_sys ctrlSetText _s;
	
	if(ACV_NetMsg) then {
		R3F_CrossRoad = format["%1 par %2",_s, (name player)];
		publicVariable R3F_CrossRoad;
	};
};
if(_mk_mun) then { // Creation des muns
	_class = (ACV_MUN select _idx) select 0;
	_displayname = (ACV_MUN select _idx) select 1;
	ACV_Void = [_class, _pos, _dir] call FNCT_MakeVehicleA;
    _veh = ACV_Void;    	
	sleep 0.01;
	ACV_Void addWeaponCargo ["LaserDesignator" , 10];
	ACV_Void addMagazineCargo ["Laserbatteries" , 10];
	ACV_Void addMagazineCargo ["PipeBomb" , 10];
	sleep 0.01;
	[ACV_Void,grpnull,false] call ACV_FNCT_StockUnit;
	sleep 0.01;
	_s = format["%1 créé",_displayname];	
	_txt_sys ctrlSetText _s;
	
	if(ACV_NetMsg) then {
		R3F_CrossRoad = format["%1 par %2",_s, (name player)];
		publicVariable R3F_CrossRoad;
	};
};
if(_mk_obj) then { // Creation des objets
	_idx = lbCurSel _cb_obj;
	_class = _cb_obj lbdata _idx;
	_displayname = _cb_obj lbtext _idx;
	ACV_Void = _class createVehicle _pos;
    sleep 0.01;
	ACV_Void setDir _dir;
    sleep 0.01;
    
    [ACV_Void,_group,false] call ACV_FNCT_StockUnit;
    
	_s = format["%1 créé",_displayname];	
	_txt_sys ctrlSetText _s;
	
	if(ACV_NetMsg) then {
		R3F_CrossRoad = format["%1 par %2",_s, (name player)];
		publicVariable R3F_CrossRoad;
	};
};



if((!_mk_mun) && (!_mk_obj)) then {
	/* Création du groupe */
	if(ACV_Default_Lead == 0) then {
		[player] joinSilent _group;
		_group selectLeader player; 
	};

	if( (ACV_Default_WayPoint>0) && (_group != grpNull) && (ACV_Default_Lead == 1) ) then {
		_rayon = abs parseNumber (ctrlText _edit_rayon);
		if( _rayon > 5000 ) then {
			_rayon = 5000;
		};
		ACV_Default_Rayon = _rayon;

		_wp = (waypoints _group) select 0;		
		_wp setWaypointPosition [_pos, _rayon];
		sleep 0.01;
	};

};

call ACV_FNCT_CancelMakeUnit;

